//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;

namespace Testing
{
	struct Complex
	{
		double real;
		double imag;
		public Complex(double real, double imag)
		{
			this.real = real;
			this.imag = imag;
		}
		public override string ToString()
		{
			return (string.Format("({0}, {1}i)", real, imag));
		}
		public static explicit operator Complex(double r)
		{
			return new Complex(r, 0);
		}
		public static implicit operator Complex(double [] n)
		{
			if(n.Length != 2)
				throw new ArgumentException();
			return new Complex(n[0], n[1]);
		}
	}
	
	class ExplicitMain
	{
		static void Main(string[] args)
		{
			Complex cn = new Complex(1,0);
			Console.WriteLine("{0}", cn);
			cn = (Complex)2;
			Console.WriteLine("{0}", cn);
			double [] da = new double [] {3,0};
			cn = da;
			Console.WriteLine("{0}", cn);
		}
	}
}
